#!/usr/bin/php
<?php
error_reporting(E_ALL);

$max_time = 30;
$shrink = false;
$overwrite = false;
$error = 's';
$files = array();
//read the command line
for($i = 1; isset($argv[$i]); $i++)
{
	switch($argv[$i])
	{
		case '-m': case '--max':
		if(!isset($argv[++$i]) || (int) $argv[$i] == 0) {$max_error = true;}
		else {$max_time = (int) $argv[$i];}
		break;
		case '-s': case '--shrink':
		if(!isset($argv[++$i])) {$shrink_error = true;}
		elseif($argv[$i] == 'n' || $argv[$i] == 'no') {$shrink = false;}
		elseif($argv[$i] == 'y' || $argv[$i] == 'yes') {$shrink = true;}
		else {$shrink_error = true;}
		break;
		case '-e': case '--error':
		if(!isset($argv[++$i])) {$error_error = true;}
		elseif($argv[$i] == 'p' || $argv[$i] == 'pass') {$error = 'p';}
		elseif($argv[$i] == 'r' || $argv[$i] == 'remove') {$error = 'r';}
		elseif($argv[$i] == 's' || $argv[$i] == 'stop') {$error = 's';}
		else {$error_error = true;}
		break;
		case '-o': case '--overwrite':
		$overwrite = true;
		break;
		case '-?': case '-h': case '--help':
		$syntax = true;
		break;
		default:
		if($argv[$i][0] == '-') {$syntax = true;}
		else {$files[] = $argv[$i];}
	}
}

echo "ttycat, a .ttyrec concatenator by Sven Zühlsdorf aka Nidan\nPlease report bugs to Nidan on irc://chat.freenode.net\n\n";

if(isset($syntax) || $argc == 1)
{
	echo "Syntax: ".$argv[0]." [OPTIONS] output_file input_file ...\nOptions:\n"
		."-m --max integer - maximum frame duration, seconds\n"
		."-s --shrink [y|n|yes|no] - try to shrink the frames\n"
		."-e --error [p|r|s|pass|remove|stop] - if an error is detected while shrinking: pass that frame to the output, remove the error or abort this script. Default is stop.\n"
		."-o --overwrite - overwrite output_file if it exists\n"
		."-? -h --help - display this help\n";
	die();
}
if(isset($max_error)) {echo "Invalid parameter for option max_time; integer expected\n"; die();}
if(isset($shrink_error)) {echo "Invalid parameter for option shrink; y/n/yes/no expected\n"; die();}
if(count($files) < 2) {echo "No input files specified\n"; die();}
//check file existance/absense
if(file_exists($files[0]) && !$overwrite) {echo "The output file ".$files[0]." exists, use -o to overwrite it\n"; die();}
elseif(file_exists($files[0])) {unlink($files[0]);}
for($i = 1; $i < count($files); $i++) {if(!file_exists($files[$i])) {echo "The input file ".$files[$i]." doesn't exist\n"; die();}}

//we want more time...
ini_set('max_execution_time', 0);

require_once('ttycat.php');
$cat_error = '';

$out = $files[0];
unset($files[0]);
if(!ttycat($out, true, $files, $max_time, $shrink, $error, $cat_error)) {echo str_replace(array('&lt;', '&gt;', '<br>'), array('<', '>', ''),$cat_error)."\n"; unlink($out);}

?>
