<?php

/** converts the given 4 byte little endian string into an unsigned integer
	returns -1 on error
*/
function decode($str)
{
	if(strlen($str) != 4) {return -1;}
	$int = 0;
	for($i = 0; $i < 4; $i++)
	{
		$int += ord($str[$i]) * pow(256, $i);
	}
	return $int;
}

/** converts an positive signed 32 bit integer into a 4 byte little endian string
	with usec == true, the maximum value is limited to 999.999
	returns an empty string on error
*/
function encode($int, $usec = false)
{
	//allow only positive values fitting a signed 32bit int
	if($int < 0 || $int > 2147483647) {return '';}
	if($usec && $int > 999999) {return '';}
	
	$str = '';
	for($i = 0; $i < 4; $i++)
	{
		$str .= chr(($int >> (8 * $i)) % 256);
	}
	return $str;
}

/** Concatenates the given ttyrecs and adjusts thier timestamps
	$out_name - string - name of the output file if $file is true, else $out_name will contain the output
	$in - array - array of the names of the input files
	$max_time - int - maximum duration of a frame, in seconds
	$shrink - bool - true if the frames should be tried to shrink (warning: uses lots of time and cpu!)
*/
function ttycat(&$out_name, $file, $in, $max_time = 30, $shrink = false, $error_handling, &$error = '')
{
	if($shrink) {require_once('ttycat_shrink.php');}//include the shrinking algorithm
	
	$max_time = (int) $max_time;
	
	if($file) {$out = fopen($out_name, 'wb');}
	else {$out = '';}//just in case someone doesn't allow file creation -- which is the case on my university server
	
	$out_sec = -$max_time;
	$out_usec = 0;
	$error = '';
	
	foreach($in as $i => $ttyrec_file)
	{
		$f = fopen($in[$i], 'rb');
		$bytes_left = filesize($in[$i]);
		
		//show the last frame of the previous ttyrec $max_time seconds
		$last_sec = decode(fread($f, 4)) - $max_time;
		$last_usec = decode(fread($f, 4));
		rewind($f);
		
		if($shrink) {shrink_frame(false, false);}
		
		while($bytes_left > 0)
		{
			$sec = decode(fread($f, 4));
			$usec = decode(fread($f, 4));
			$len = decode(fread($f, 4));
			$data = fread($f, min($len, $bytes_left - 12));
			if($sec == -1 || $usec == -1 || $len == -1 || strlen($data) != $len)
			{
				$error = 'Error while reading "'.$in[$i].'": Frame starting at Byte '.(filesize($in[$i]) - $bytes_left).' is invalid.';
				fclose($f);
				break 2;
			}
			
			$diff_sec = $sec - $last_sec;
			$diff_usec = $usec - $last_usec;
			
			//fix invalid times
			while($diff_usec < 0)
			{
				$diff_usec += 1000000;
				$diff_sec--;
			}
			while($diff_usec >= 1000000)
			{
				$diff_usec -= 1000000;
				$diff_sec++;
			}
			if($diff_sec < 0) {$diff_sec = 0;}
			elseif($diff_sec >= $max_time)
			{
				$diff_sec = $max_time;
				$diff_usec = 0;
			}
			
			//calculate output time, try to shorten and append this frame
			$out_sec += $diff_sec;
			$out_usec += $diff_usec;
			while($out_usec >= 1000000)
			{
				$out_usec -= 1000000;
				$out_sec++;
			}
			
			$shrink_error = '';
			if($shrink) {$shrinked_data = shrink_frame($data, $error_handling == 'r', $shrink_error);}
			if($shrink && is_bool($shrinked_data) && $shrinked_data == false && $error_handling == 's')
			{
				$error = 'Error while shrinking "'.$in[$i].'": Frame starting at Byte '.(filesize($in[$i]) - $bytes_left).': '.$shrink_error.'<br>';
				fclose($f);
				break 2;
			}
			elseif($shrink && strlen($data) > strlen($shrinked_data) && $shrinked_data != false)
			{
				$data = $shrinked_data;
			}
			if($shrink && is_string($data) && $data == '')
			{//shrinking produced an empty frame
				$sec = $last_sec;
				$usec = $last_usec;
			}
			else
			{
				if($file) {fwrite($out, encode($out_sec).encode($out_usec, true).encode(strlen($data)).$data);}
				else {$out .= encode($out_sec).encode($out_usec, true).encode(strlen($data)).$data;}
			}
			$bytes_left -= (12 + $len);
			
			//if(filesize($in[$i]) - $bytes_left == 1896263) die();
			
			$last_sec = $sec;
			$last_usec = $usec;
		}
		fclose($f);
	}
	if($error == '')
	{
		//We've finnished without error - append a small ad
		$lastframe = "\n".'This ttyrec was created with ttycat, a ttyrec concatenator found at'."\n".'http://ghostdub.de/~nidan/nethack/ttycat'."\n";
		if($file)
		{
			fwrite($out, encode($out_sec + $max_time).encode($out_usec, true).encode(strlen($lastframe)).$lastframe);
			fclose($out);
		}
		else {$out_name = $out.encode($out_sec + $max_time).encode($out_usec, true).encode(strlen($lastframe)).$lastframe;}
		return true;
	}
	return false;
}

?>
